<?php

namespace App\Controllers\Admin;

use App\Controllers\BaseController;
use App\Models\FooterModel;

class Footer extends BaseController
{
    protected $footerModel;

    public function __construct()
    {
        $this->footerModel = new FooterModel();
    }

    public function index()
    {
        $footer = $this->footerModel->first();

        // jika belum ada data, buat 1 baris otomatis
        if (!$footer) {
            $this->footerModel->insert([
                'phone'     => '',
                'email'     => '',
                'facebook'  => '',
                'instagram' => '',
                'youtube'   => '',
            ]);
            $footer = $this->footerModel->first();
        }

        return view('admin/footer/index', [
            'footer' => $footer
        ]);
    }

    public function update($id)
    {
        $this->footerModel->update($id, [
            'phone'     => $this->request->getPost('phone'),
            'email'     => $this->request->getPost('email'),
            'facebook'  => $this->request->getPost('facebook'),
            'instagram' => $this->request->getPost('instagram'),
            'youtube'   => $this->request->getPost('youtube'),
        ]);
    
        return redirect()->back()->with('success', 'Footer berhasil diperbarui');
    }
}
